/*
********************************************************************************
** SAE J1699-3 Test Source Code
**
**  Copyright (C) 2002 Drew Technologies. http://j1699-3.sourceforge.net/
**
** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
**
** This source code, when compiled and used with an SAE J2534-compatible pass
** thru device, is intended to run the tests described in the SAE J1699-3
** document in an automated manner.
**
** This computer program is based upon SAE Technical Report J1699,
** which is provided "AS IS"
**
** See j1699.c for details of how to build and run this test.
**
********************************************************************************
* DATE          MODIFICATION
* 05/01/04      Renumber all test cases to reflect specification.  This section
*               has been indicated as section 9 in Draft 19.4.
********************************************************************************
*/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <windows.h>
#include "j2534.h"
#include "j1699.h"

/*
*******************************************************************************
** TestWithNoFaultsAfter3DriveCycles -
** Function to run test with no faults after 3 drive cycles
*******************************************************************************
*/
STATUS TestWithNoFaultsAfter3DriveCycles(void)
{
    /* Prompt user to complete the second and perform the third drive cycle */
    LogPrint("\n\n**** Test 9.1 (No faults after 3 drive cycles) ****\n");
    LogUserPrompt("Turn key off for at least thirty (30) seconds\n"
                  "(this completes two driving cycles)", ENTER_PROMPT);
    LogUserPrompt("Start engine and let idle for whatever time it takes to run the monitor\n"
                  "and detect that there is no malfunction", ENTER_PROMPT);
    LogUserPrompt("Turn key off for at least thirty (30) seconds\n"
                  "(this completes the three driving cycles with no fault)", ENTER_PROMPT);
    LogUserPrompt("Start engine and let idle for one (1) minute",
    ENTER_PROMPT);
    gOBDEngineRunning = TRUE;

	LogPrint("**** Test 9.1 PASSED ****\n");
    
    /* Set flag to indicate DTC should be historical */
    gOBDDTCHistorical = TRUE;

    /* Determine the OBD protocol to use */
    LogPrint("\n\n**** Test 9.2 ****\n");
    if (DetermineProtocol() != PASS)
    {
        LogPrint("**** Test 9.2 FAILED ****\n");
        if (LogUserPrompt("Protocol determination failed. Continue?", YES_NO_PROMPT) == 'N')
        {
            return(FAIL);
        }
        gOBDFailureBypassed = TRUE;
    }
    else
    {
        LogPrint("**** Test 9.2 PASSED ****\n");
    }

    /* Verify pending DTC data */
    LogPrint("\n\n**** Test 9.3 ****\n");
    if (VerifyDTCPendingData() != PASS)
    {
        LogPrint("**** Test 9.3 FAILED ****\n");
        if (LogUserPrompt("DTC pending data failed. Continue?", YES_NO_PROMPT) == 'N')
        {
            return(FAIL);
        }
        gOBDFailureBypassed = TRUE;
    }
    else
    {
        LogPrint("**** Test 9.3 PASSED ****\n");
    }

    /* Verify stored DTC data */
    LogPrint("\n\n**** Test 9.4 ****\n");
    if (VerifyDTCStoredData() != PASS)
    {
        LogPrint("**** Test 9.4 FAILED ****\n");
        if (LogUserPrompt("DTC stored data failed. Continue?", YES_NO_PROMPT) == 'N')
        {
            return(FAIL);
        }
        gOBDFailureBypassed = TRUE;
    }

    /* Verify MIL and DTC status is cleared */
    if (VerifyMILData() != PASS)
    {
        LogPrint("**** Test 9.4 FAILED ****\n");
        if (LogUserPrompt("MIL / DTC status failed. Continue?", YES_NO_PROMPT) == 'N')
        {
            return(FAIL);
        }
        gOBDFailureBypassed = TRUE;
    }
    else
    {
        LogPrint("**** Test 9.4 PASSED ****\n");
    }

    /* Verify freeze frame support and data */
    LogPrint("\n\n**** Test 9.5 ****\n");
    if (VerifyFreezeFrameSupportAndData() != PASS)
    {
        LogPrint("**** Test 9.5 FAILED ****\n");
        if (LogUserPrompt("Freeze frame support/data failed. Continue?", YES_NO_PROMPT) == 'N')
        {
            return(FAIL);
        }
        gOBDFailureBypassed = TRUE;
    }
    else
    {
        LogPrint("**** Test 9.5 PASSED ****\n");
    }

	/* Link active test to verify communication remained active for ALL protocols
	 */
	if (VerifyLinkActive() != PASS)
	{
		return( FAIL );
	}

	/* added test 9.6 clear code in engine off status*/
	if (LogUserPrompt("Clear all diagnostic information?", YES_NO_PROMPT) != 'N') 
	{
        LogPrint("\n\n**** Test 9.6 ****\n");
		if (LogUserPrompt("Clear codes engine running?", YES_NO_PROMPT) != 'Y') 
		{
			LogUserPrompt("Turn key OFF for at least 30 seconds.", ENTER_PROMPT);
			LogUserPrompt("Turn key ON with engine OFF. Do not crank engine.", ENTER_PROMPT);
		
			if (DetermineProtocol() != PASS) 
			{
				if ( LogUserPrompt("Protocol determination failed. Continue?", YES_NO_PROMPT) == 'N') 
				{
					LogPrint("**** Test 9.6 FAILED ****\n");
					LogUserPrompt("Turn key OFF", ENTER_PROMPT);
					return(FAIL);
        		}
				else
                {		
					LogPrint("**** Test 9.6 FAILED ****\n");
					gOBDFailureBypassed = TRUE;
				}
			}
			else 
			{ 
				LogPrint("\nINFORMATION: Protocol determination passed.\n");
				if (ClearCodes() != PASS) 
				{
            	    if ( LogUserPrompt("Clear diagnostic information failed. Continue?", YES_NO_PROMPT) == 'N') 
					{
            		    LogPrint("\n**** Test 9.6 FAILED ****\n");
				  		LogUserPrompt("Turn key OFF", ENTER_PROMPT);
				  		return(FAIL);
					}
					else
					{
				  		LogPrint("\n**** Test 9.6 FAILED ****\n");
						gOBDFailureBypassed = TRUE;
					}
        		}
				else 
				{
		    		LogPrint("\nINFORMATION: Cleared diagnostics information successfully.\n");
		    		LogPrint("**** Test 9.6 PASSED ****\n");
				}
			}
		}
		else
		{
			if (ClearCodes() != PASS) 
			{
                if ( LogUserPrompt("Clear diagnostic information failed. Continue?", YES_NO_PROMPT) == 'N') 
				{
             	    LogPrint("\n**** Test 9.6 FAILED ****\n");
			  		LogUserPrompt("Turn key OFF", ENTER_PROMPT);
			  		return(FAIL);
				}
				else
				{
			  		LogPrint("\n**** Test 9.6 FAILED ****\n");
					gOBDFailureBypassed = TRUE;
				}
        	}
			else 
			{
		    	LogPrint("\nINFORMATION: Cleared diagnostics information successfully.\n");
		    	LogPrint("**** Test 9.6 PASSED ****\n");
			}
		}

		LogUserPrompt("Turn key OFF", ENTER_PROMPT);
	}
    return(PASS);
}
