/*
 * This is the CarDAQ+ header file. The CarDAQ+ supports the full
 * J2534-1 v0202 API, plus some extensions. The extensions are marked
 * as follows:
 *    "-2" = Feature from the J2534-2 Specification
 *    "v4" = Forward-compatiable feature from J2534-1 v0404 API
 *    "DT" = DrewTech-specific feature, not yet standardized
 *
 * Copyright 2004 Drew Technologies, Inc.
 */

#ifndef __J2534_H
#define __J2534_H


/**************************/
/* ProtocolID definitions */
/**************************/
#define J1850VPW					1
#define J1850PWM					2
#define ISO9141						3
#define ISO14230					4
#define CAN							5
#define ISO15765					6
#define SCI_A_ENGINE				7
#define SCI_A_TRANS					8
#define SCI_B_ENGINE				9
#define SCI_B_TRANS					10

// J2534-2 Pin Switched ProtocolIDs
#define J1850VPW_PS			/*-2*/			0x8000 // Not supported
#define J1850PWM_PS			/*-2*/			0x8001 // Not supported
#define ISO9141_PS			/*-2*/			0x8002 // Not supported
#define ISO14230_PS			/*-2*/			0x8003 // Not supported
#define CAN_PS				/*-2*/			0x8004
#define ISO15765_PS			/*-2*/			0x8005
#define J2610_PS			/*-2*/			0x8006 // Not supported
#define SW_ISO15765_PS		/*-2*/			0x8007
#define SW_CAN_PS			/*-2*/			0x8008
#define GM_UART_PS			/*-2*/			0x8009 // Not supported (YET)
#define UART_ECHO_BYTE_PS	/*-2*/			0x800A
#define HONDA_DIAGH_PS  	/*-2*/			0x800B // Not supported 
#define J1939_PS  	        /*-2*/			0x800C // Not supported
#define J1708_PS  	        /*-2*/			0x800D
#define TP2_0_PS  	        /*-2*/			0x800E // Not supported

#define ANALOG_IN_1			/*-2*/			0xC000
#define ANALOG_IN_2			/*-2*/			0xC001 // Supported on AVIT only
#define ANALOG_IN_32		/*-2*/			0xC01F // Not supported

#define DT_ANALOG_IN_1		/*DT*/			0x800B // Old Drew Tech Analogs do not use in new designs
#define DT_ANALOG_IN_2		/*DT*/			0x800C // Old Drew Tech Analogs do not use in new designs
#define DT_J1708_PS  	    /*DT*/			0x10000001   // Old Drew Tech J1708 do not use in new designs
 

/*************/
/* IOCTL IDs */
/*************/
#define GET_CONFIG						0x01
#define SET_CONFIG						0x02
#define READ_VBATT						0x03
#define FIVE_BAUD_INIT					0x04
#define FAST_INIT						0x05
// unused							0x06
#define CLEAR_TX_BUFFER						0x07
#define CLEAR_RX_BUFFER						0x08
#define CLEAR_PERIODIC_MSGS					0x09
#define CLEAR_MSG_FILTERS					0x0A
#define CLEAR_FUNCT_MSG_LOOKUP_TABLE		0x0B
#define ADD_TO_FUNCT_MSG_LOOKUP_TABLE		0x0C
#define DELETE_FROM_FUNCT_MSG_LOOKUP_TABLE	0x0D
#define READ_PROG_VOLTAGE					0x0E
// J2534-2 SW_CAN
#define SW_CAN_HS			/*-2*/			0x8000
#define SW_CAN_NS			/*-2*/			0x8001
// J2534-2 Device Config Parameters
#define GET_DEVICE_CONFIG	/*-2*/			0x8007
#define SET_DEVICE_CONFIG	/*-2*/			0x8008
// J2534-2 J1939 
#define PROTECT_J1939_ADDR	/*-2*/			0x8009
// J2534-2 TP2.0 
#define REQUEST_CONNECTION              	0x800A
#define TEARDOWN_CONNECTION             	0x800B
// J2534-2 Discovery Mechanism 
#define GET_DEVICE_INFO                 	0x800C
#define GET_PROTOCOL_INFO               	0x800D

// DT CarDAQ2534 Ioctl values to read most recent analog sample (Flushes all samples in queue)
#define READ_CH1_VOLTAGE		/*DT*/			0x10000
#define READ_CH2_VOLTAGE		/*DT*/			0x10001
#define READ_CH3_VOLTAGE		/*DT*/			0x10002
#define READ_CH4_VOLTAGE		/*DT*/			0x10003
#define READ_CH5_VOLTAGE		/*DT*/			0x10004
#define READ_CH6_VOLTAGE		/*DT*/			0x10005
// DT CarDAQ2534 Ioctl for reading block of data
#define READ_ANALOG_CH1			/*DT*/			0x10010
#define READ_ANALOG_CH2			/*DT*/			0x10011
#define READ_ANALOG_CH3			/*DT*/			0x10012
#define READ_ANALOG_CH4			/*DT*/			0x10013
#define READ_ANALOG_CH5			/*DT*/			0x10014
#define READ_ANALOG_CH6			/*DT*/			0x10015
#define READ_TIMESTAMP			/*DT*/			0x10100
#define READ_CHANNEL_ERRORS		/*DT*/			0x10101 // input = Num values, output = ptr long[]
#define DT_COMMIT_CHANGES		/*DT*/			0x30000
#define GET_DEVICE_BYTE_ARRAY	/*DT*/			0x30001 // input = SBYTE_ARRAY, output = define
#define SET_DEVICE_BYTE_ARRAY	/*DT*/			0x30002 // input = SBYTE_ARRAY, output = define 
#define DT_IOCTL_VVSTATS		/*DT*/			0x20000000
#define DT_READ_DIO			    /*DT*/			0x20000001 // AVIT only
#define DT_WRITE_DIO			/*DT*/			0x20000002 // AVIT only
#define DT_ANALOG_IGNORE_CAL	/*DT*/			0x20000003 // AVIT only


/*******************************/
/* Configuration Parameter IDs */
/*******************************/
#define DATA_RATE					0x01
// unused							0x02
#define LOOPBACK					0x03
#define NODE_ADDRESS				0x04
#define NETWORK_LINE				0x05
#define P1_MIN						0x06
#define P1_MAX						0x07
#define P2_MIN						0x08
#define P2_MAX						0x09
#define P3_MIN						0x0A
#define P3_MAX						0x0B
#define P4_MIN						0x0C
#define P4_MAX						0x0D
// See W0 = 0x19
#define W1							0x0E
#define W2							0x0F
#define W3							0x10
#define W4							0x11
#define W5							0x12
#define TIDLE						0x13
#define TINIL						0x14
#define TWUP						0x15
#define PARITY						0x16
#define BIT_SAMPLE_POINT			0x17
#define SYNC_JUMP_WIDTH				0x18
#define W0				    /*v4*/	0x19 //new in v0404
#define T1_MAX					   	0x1A
#define T2_MAX					   	0x1B
// See T3_MAX = 0x24
#define T4_MAX					   	0x1C
#define T5_MAX					   	0x1D
#define ISO15765_BS				   	0x1E
#define ISO15765_STMIN			  	0x1F
#define DATA_BITS			/*v4*/	0x20 //new in v0404
#define DATA_BITS_CARDAQ	/*DT*/  0x64 //CarDAQ2534 location
#define FIVE_BAUD_MOD		/*v4*/	0x21 //new in v0404
#define BS_TX				/*v4*/	0x22 //new in v0404
#define STMIN_TX			/*v4*/	0x23 //new in v0404
#define T3_MAX				/*v4*/	0x24 //new in v0404
#define ISO15765_WFT_MAX	/*v4*/	0x25 //new in v0404
#define ISO15765_SIMULTANEOUS	/*DT*/	0x10000000
#define DT_ISO15765_PAD_BYTE    /*DT*/  0x10000001
#define DT_FILTER_FREQ			/*DT*/	0x10000002 // AVIT only
#define DT_PARAM_RX_BUFFER_SIZE	/*DT*/	0x10000003
#define DT_PARAM_TX_BUFFER_SIZE	/*DT*/	0x10000004

// J2534-2
#define CAN_MIXED_FORMAT		/*-2*/			0x8000
#define J1962_PINS			    /*-2*/			0x8001
#define SW_CAN_HS_DATA_RATE		/*-2*/			0x8010
#define SW_CAN_SPEEDCHANGE_ENABLE	/*-2*/		0x8011
#define SW_CAN_RES_SWITCH		/*-2*/			0x8012
#define ACTIVE_CHANNELS			/*-2*/			0x8020
#define SAMPLE_RATE			    /*-2*/			0x8021
#define SAMPLES_PER_READING		/*-2*/			0x8022
#define READINGS_PER_MSG		/*-2*/			0x8023
#define AVERAGING_METHOD		/*-2*/			0x8024
#define SAMPLE_RESOLUTION		/*-2*/			0x8025
#define INPUT_RANGE_LOW			/*-2*/			0x8026
#define INPUT_RANGE_HIGH		/*-2*/			0x8027
// old DT analogs
#define ADC_READINGS_PER_SECOND		/*DT*/			0x10000
#define ADC_READINGS_PER_SAMPLE		/*DT*/			0x20000

// UART Echo Byte protocol parameters
#define UEB_T0_MIN             	/*-2*/			0x8028
#define UEB_T1_MAX             	/*-2*/			0x8029
#define UEB_T2_MAX             	/*-2*/			0x802A
#define UEB_T3_MAX             	/*-2*/			0x802B
#define UEB_T4_MIN             	/*-2*/			0x802C
#define UEB_T5_MAX             	/*-2*/			0x802D
#define UEB_T6_MAX             	/*-2*/			0x802E
#define UEB_T7_MIN             	/*-2*/			0x802F
#define UEB_T7_MAX             	/*-2*/			0x8030
#define UEB_T9_MIN             	/*-2*/			0x8031
 
#define J1939_PINS             	/*-2*/			0x803D
#define J1708_PINS             	/*-2*/			0x803E

#define J1939_T1             	/*-2*/			0x803F
#define J1939_T2             	/*-2*/			0x8040
#define J1939_T3             	/*-2*/			0x8041
#define J1939_T4             	/*-2*/			0x8042
#define J1939_BRDCST_MIN_DELAY 	/*-2*/			0x8043

// J2534-2 TP2.0
#define TP2_0_T_BR_INT      	/*-2*/         	0x8044
#define TP2_0_T_E            	/*-2*/      	0x8045
#define TP2_0_MNTC          	/*-2*/      	0x8046
#define TP2_0_T_CTA      	    /*-2*/	        0x8047
#define TP2_0_MNCT       	    /*-2*/	        0x8048
#define TP2_0_MNTB          	/*-2*/	        0x8049
#define TP2_0_MNT      	        /*-2*/	        0x804A
#define TP2_0_T_WAIT      	    /*-2*/	        0x804B
#define TP2_0_T1      	        /*-2*/	        0x804C
#define TP2_0_T3      	        /*-2*/	        0x804D
#define TP2_0_IDENTIFER      	/*-2*/	        0x804E
#define TP2_0_RXIDPASSIVE      	/*-2*/	        0x804F

// Device Config parameters
#define NON_VOLATILE_STORE_1	/*-2*/			0xC001
#define NON_VOLATILE_STORE_2	/*-2*/			0xC002
#define NON_VOLATILE_STORE_3	/*-2*/			0xC003
#define NON_VOLATILE_STORE_4	/*-2*/			0xC004
#define NON_VOLATILE_STORE_5	/*-2*/			0xC005
#define NON_VOLATILE_STORE_6	/*-2*/			0xC006
#define NON_VOLATILE_STORE_7	/*-2*/			0xC007
#define NON_VOLATILE_STORE_8	/*-2*/			0xC008
#define NON_VOLATILE_STORE_9	/*-2*/			0xC009
#define NON_VOLATILE_STORE_10	/*-2*/			0xC00A

//DT Device Config Parameters
#define DC_NETWORK_TYPE			/*DT*/			0x30000		/* use SCONFIG_LIST */
#define DC_FIXED_IP_ADDR		/*DT*/			0x30001		/* use SCONFIG_LIST */
#define DC_NW_NET_MASK		/*DT*/			    0x30002		/* use SCONFIG_LIST */
#define DC_NW_GATEWAY		/*DT*/			    0x30003		/* use SCONFIG_LIST */
#define DC_NW_SERVER_IP_ADDR		/*DT*/		0x30004		/* use SCONFIG_LIST */
#define DC_WIRELESS_NETWORK_TYPE	/*DT*/		0x30005		/* use SCONFIG_LIST */
#define DC_WIRELESS_FIXED_IP_ADDR	/*DT*/		0x30006		/* use SCONFIG_LIST */
#define DC_WIRELESS_NET_MASK	/*DT*/			0x30007		/* use SCONFIG_LIST */
#define DC_WIRELESS_GATEWAY	    /*DT*/	    	0x30008		/* use SCONFIG_LIST */
#define DC_WIRELESS_MODE		/*DT*/			0x30009		/* use SCONFIG_LIST Ad-Hoc = 0, Managed, Master, Repeater, Secondary, auto*/
#define DC_WIRELESS_CHANNEL		/*DT*/			0x3000A		/* use SCONFIG_LIST */
#define DC_WIRELESS_RATE		/*DT*/			0x3000B		/* use SCONFIG_LIST Auto = 0, 1M, 2M, 5M, 11M */
#define DC_FILE_SERVER_ENABLE	/*DT*/			0x3000C		/* use SCONFIG_LIST */
#define DC_TELNET_SERVER_ENABLE	/*DT*/			0x3000D		/* use SCONFIG_LIST */
#define DC_AUTO_RUN_ENABLE		/*DT*/			0x3000E		/* use SCONFIG_LIST */
#define DC_WEB_SERVER_ENABLE	/*DT*/			0x3000F		/* use SCONFIG_LIST */

#define DCBA_WIRELESS_ESSID		/*DT*/			0x30100		/* define for GET_DEVICE_BYTE_ARRAY */
#define DCBA_NETWORK_NAME		/*DT*/			0x30101		/* define for GET_DEVICE_BYTE_ARRAY */

// J2534-2 GET_DEVICE_INFO defines
#define SERIAL_NUMBER         	/*-2*/		0x0001
#define J1850PWM_SUPPORTED     	/*-2*/  	0x0002
#define J1850VPW_SUPPORTED     	/*-2*/  	0x0003
#define ISO9141_SUPPORTED      	/*-2*/  	0x0004
#define ISO14230_SUPPORTED     	/*-2*/  	0x0005
#define CAN_SUPPORTED         	/*-2*/  	0x0006
#define ISO15765_SUPPORTED     	/*-2*/  	0x0007
#define SCI_A_ENGINE_SUPPORTED 	/*-2*/  	0x0008
#define SCI_A_TRANS_SUPPORTED  	/*-2*/  	0x0009
#define SCI_B_ENGINE_SUPPORTED 	/*-2*/  	0x000A
#define SCI_B_TRANS_SUPPORTED  	/*-2*/  	0x000B
#define SW_ISO15765_SUPPORTED  	/*-2*/  	0x000C
#define SW_CAN_SUPPORTED      	/*-2*/  	0x000D
#define UART_ECHO_BYTE_SUPPORTED   	/*-2*/  	0x000F
#define J1939_SUPPORTED      	/*-2*/  	0x0011
#define J1708_SUPPORTED      	/*-2*/  	0x0012
#define TP2_0_SUPPORTED      	/*-2*/  	0x0013
#define ANALOG_IN_SUPPORTED     /*-2*/  	0x0015
#define MAX_NON_VOLATILE_STORAGE   	/*-2*/  	0x0016
#define SHORT_TO_GND_J1962      /*-2*/  	0x0017
#define PGM_VOLTAGE_J1962      	/*-2*/  	0x0018
#define CAN_PS_J1962            /*-2*/  	0x001F
#define ISO15765_PS_J1962      	/*-2*/  	0x0020
#define SW_CAN_PS_J1962      	/*-2*/  	0x0021
#define SW_ISO15765_PS_J1962    /*-2*/  	0x0022
#define UART_ECHO_BYTE_PS_J1962 /*-2*/  	0x0024
#define J1708_PS_J1962      	/*-2*/  	0x0027
#define TP2_0_PS_J1962      	/*-2*/  	0x0028
#define J1939_PS_J1939      	/*-2*/  	0x002A
#define J1708_PS_J1708      	/*-2*/  	0x0030

// J2534-2 GET_PROTOCOL_INFO defines
#define MAX_RX_BUFFER_SIZE      /*-2*/	    0x0001
#define MAX_PASS_FILTER         /*-2*/	    0x0002
#define MAX_BLOCK_FILTER        /*-2*/	    0x0003
#define MAX_FILTER_MSG_LENGTH   /*-2*/	    0x0004
#define MAX_PERIODIC_MSGS       /*-2*/	    0x0005
#define MAX_PERIODIC_MSG_LENGTH /*-2*/	    0x0006
#define DESIRED_DATA_RATE       /*-2*/	    0x0007
#define MAX_REPEAT_MESSAGING    /*-2*/	    0x0008
#define MAX_REPEAT_MESSAGING_LENGTH     /*-2*/	    0x0009
#define NETWORK_LINE_SUPPORTED  /*-2*/	    0x000A
#define MAX_FUNCT_MSG_LOOKUP    /*-2*/	    0x000B
#define PARITY_SUPPORTED        /*-2*/	    0x000C
#define DATA_BITS_SUPPORTED     /*-2*/	    0x000D
#define FIVE_BAUD_MOD_SUPPORTED /*-2*/	    0x000E
#define L_LINE_SUPPORTED        /*-2*/	    0x000F
#define CAN_11_29_IDS_SUPPORTED /*-2*/	    0x0010
#define CAN_MIXED_FORMAT_SUPPORTED     /*-2*/	    0x0011
#define MAX_FLOW_CONTROL_FILTER /*-2*/	    0x0012
#define MAX_ISO15765_WFT_MAX    /*-2*/	    0x0013
#define MAX_AD_ACTIVE_CHANNELS  /*-2*/	    0x0014
#define MAX_AD_SAMPLE_RATE      /*-2*/	    0x0015
#define MAX_AD_SAMPLES_PER_READING     /*-2*/	    0x0016
#define AD_SAMPLE_RESOLUTION    /*-2*/	    0x0017
#define AD_INPUT_RANGE_LOW      /*-2*/	    0x0018
#define AD_INPUT_RANGE_HIGH     /*-2*/	    0x0019

/*************/
/* Error IDs */
/*************/
#define STATUS_NOERROR					0x00
#define ERR_NOT_SUPPORTED				0x01
#define ERR_INVALID_CHANNEL_ID			0x02
#define ERR_INVALID_PROTOCOL_ID			0x03
#define ERR_NULL_PARAMETER		/*DT*/	0x04 //DT name
#define ERR_NULLPARAMETER				0x04 // brain-dead spec name
#define ERR_INVALID_IOCTL_VALUE			0x05
#define ERR_INVALID_FLAGS				0x06
#define ERR_FAILED						0x07
#define ERR_DEVICE_NOT_CONNECTED		0x08
#define ERR_TIMEOUT						0x09
#define ERR_INVALID_MSG					0x0A
#define ERR_INVALID_TIME_INTERVAL		0x0B
#define ERR_EXCEEDED_LIMIT				0x0C
#define ERR_INVALID_MSG_ID				0x0D
#define ERR_INVALID_ERROR_ID			0x0E /*?*/
#define ERR_INVALID_IOCTL_ID			0x0F
#define ERR_BUFFER_EMPTY				0x10
#define ERR_BUFFER_FULL					0x11
#define ERR_BUFFER_OVERFLOW				0x12
#define ERR_PIN_INVALID					0x13
#define ERR_CHANNEL_IN_USE				0x14
#define ERR_MSG_PROTOCOL_ID				0x15

#define ERR_ADDRESS_NOT_CLAIMED	/*-2*/		0x10000

/*****************************/
/* Miscellaneous definitions */
/*****************************/
#define SHORT_TO_GROUND					0xFFFFFFFE
#define VOLTAGE_OFF						0xFFFFFFFF

#define NO_PARITY						0
#define ODD_PARITY						1
#define EVEN_PARITY						2

//SWCAN
#define DISBLE_SPDCHANGE		/*-2*/			0
#define ENABLE_SPDCHANGE		/*-2*/			1
#define DISCONNECT_RESISTOR		/*-2*/			0
#define CONNECT_RESISTOR		/*-2*/			1
#define AUTO_RESISTOR			/*-2*/			2

//Mixed Mode
#define CAN_MIXED_FORMAT_OFF	/*-2*/			0
#define CAN_MIXED_FORMAT_ON		/*-2*/			1
#define CAN_MIXED_FORMAT_ALL_FRAMES	/*-2*/		2 // Not supported

// -2 Discovery
#define NOT_SUPPORTED       0
#define SUPPORTED           1

/*******************************/
/* PassThruConnect definitions */
/*******************************/
#define ISO15765_ADDR_TYPE					0x00000080 // Not used. Use in TxFlags instead.
#define ISO15765_EXT_ADDR		/*DT*/		0x00000080 // Not used. Accidentally refered to in spec
#define CAN_EXTENDED_ID						0x00000100
#define CAN_29BIT_ID			/*v4*/		0x00000100 //renamed in v0404
#define ISO9141_NO_CHECKSUM_DT	/*v4*/		0x00000200 //new in v0404
#define NO_CHECKSUM				/*-2*/      0x00000200
#define CAN_ID_BOTH			    /*v4*/		0x00000800 //new in v0404
#define ISO9141_K_LINE_ONLY		/*v4*/		0x00001000 //new in v0404

#define SNIFF_MODE			    /*DT*/		0x10000000 //DT - J1850PWM, J1850VPW, ISO9141
#define LISTEN_ONLY_DT      	/*DT*/		0x10000000 //DT - listen only mode CAN
#define ISO9141_FORD_HEADER		/*DT*/		0x20000000 //CarDAQ2534
#define ISO9141_NO_CHECKSUM		/*DT*/		0x40000000 //CarDAQ2534 location
#define CONNECT_ETHERNET_ONLY	/*DT*/		0x80000000 // <unsupported>


/************************/
/* RxStatus definitions */
/************************/
#define TX_MSG_TYPE						0x00000001
#define ISO15765_FIRST_FRAME			0x00000002
#define START_OF_MESSAGE	/*v4*/		0x00000002 //renamed in v0404
#define RX_BREAK						0x00000004
#define TX_DONE				/*v4*/		0x00000008 //new in v0404, we show in Rx
#define ISO15765_PADDING_ERROR	/*v4*/	0x00000010 //new in v0404, we show in Rx
//	ISO15765_ADDR_TYPE		/*DT*/		0x00000080 //defined above. we show in Rx
//	CAN_29BIT_ID						0x00000100 //defined above
//	CAN_EXTENDED_ID			/*v4*/		0x00000100 //defined above
#define	SW_CAN_NS_RX		/*-2*/		0x00040000
#define	SW_CAN_HS_RX		/*-2*/		0x00020000
#define	SW_CAN_HV_RX		/*-2*/		0x00010000


/***********************/
/* TxFlags definitions */
/***********************/
#define ISO15765_FRAME_PAD				0x00000040
//      ISO15765_ADDR_TYPE				0x00000080  defined above
//	CAN_29BIT_ID						0x00000100  defined above
//	CAN_EXTENDED_ID			/*v4*/		0x00000100 //defined above
#define WAIT_P3_MIN_ONLY	/*v4*/		0x00000200 //new in v0404
#define SW_CAN_HV_TX		/*-2*/		0x00000400
#define BLOCKING						0x00010000
#define TX_BLOCKING			/*DT*/		0x00010000 //DT name for BLOCKING
#define SCI_TX_VOLTAGE					0x00800000
#define SCI_MODE			/*v4*/		0x00400000 //new in v0404
#define DT_PERIODIC_UPDATE	/*DT*/		0x10000000 //DT


/**********************/
/* Filter definitions */
/**********************/
#define PASS_FILTER						    0x00000001
#define BLOCK_FILTER						0x00000002
#define FLOW_CONTROL_FILTER					0x00000003
#define PASS_FILTER_WITH_TRIGGER	/*DT*/	0x10000005 //DT
#define BLOCK_FILTER_WITH_TRIGGER	/*DT*/	0x10000006 //DT


/*********************/
/* Message Structure */
/*********************/
typedef struct
{
	unsigned long ProtocolID;
	unsigned long RxStatus;
	unsigned long TxFlags;
	unsigned long Timestamp;
	unsigned long DataSize;
	unsigned long ExtraDataIndex;
	unsigned char Data[4128];
} PASSTHRU_MSG;


/********************/
/* IOCTL Structures */
/********************/
typedef struct
{
	unsigned long Parameter;
	unsigned long Value;
} SCONFIG;

typedef struct
{
	unsigned long NumOfParams;
	SCONFIG *ConfigPtr;
} SCONFIG_LIST;

typedef struct
{
	unsigned long NumOfBytes;
	unsigned char *BytePtr;
} SBYTE_ARRAY;

typedef struct
{
	unsigned long Parameter;
	unsigned long Value;
    unsigned long Supported;
} SPARAM;

typedef struct
{
	unsigned long NumOfParams;
	SPARAM *ParamPtr;
} SPARAM_LIST;

/************************/
/* Function Definitions */
/************************/
#ifdef _WIN32
#include <windows.h>
#ifndef BUILDING_DLL
// J2534 Windows Interface API defines
typedef long (CALLBACK* PTCONNECT)(unsigned long, unsigned long, unsigned long *);
typedef long (CALLBACK* PTDISCONNECT)(unsigned long);
typedef long (CALLBACK* PTREADMSGS)(unsigned long, void *, unsigned long *, unsigned long);
typedef long (CALLBACK* PTWRITEMSGS)(unsigned long, void *, unsigned long *, unsigned long);
typedef long (CALLBACK* PTSTARTPERIODICMSG)(unsigned long, void *, unsigned long *, unsigned long);
typedef long (CALLBACK* PTSTOPPERIODICMSG)(unsigned long, unsigned long);
typedef long (CALLBACK* PTSTARTMSGFILTER)(unsigned long, unsigned long, void *, void *, void *, unsigned long *);
typedef long (CALLBACK* PTSTOPMSGFILTER)(unsigned long, unsigned long);
typedef long (CALLBACK* PTSETPROGRAMMINGVOLTAGE)(unsigned long, unsigned long);
typedef long (CALLBACK* PTREADVERSION)(char *, char *, char *);
typedef long (CALLBACK* PTGETLASTERROR)(char *);
typedef long (CALLBACK* PTIOCTL)(unsigned long, unsigned long, void *, void *);
// Drew Tech specific function calls
typedef long (CALLBACK* PTLOADFIRMWARE)(void);
typedef long (CALLBACK* PTRECOVERFIRMWARE)(void);
typedef long (CALLBACK* PTREADIPSETUP)(char *host_name, char *ip_addr, char *subnet_mask,
                      char *gateway, char *dhcp_addr);
typedef long (CALLBACK* PTWRITEIPSETUP)(char *host_name, char *ip_addr, char *subnet_mask,
                      char *gateway, char *dhcp_addr);
typedef long (CALLBACK* PTREADPCSETUP)(char *host_name, char *ip_addr);
typedef long (CALLBACK* PTGETPOINTER)(long vb_pointer);
typedef long (CALLBACK* PTGETNEXTCARDAQ)(char **name, unsigned long *version, char **addr);

extern PTCONNECT PassThruConnect;
extern PTDISCONNECT PassThruDisconnect;
extern PTREADMSGS PassThruReadMsgs;
extern PTWRITEMSGS PassThruWriteMsgs;
extern PTSTARTPERIODICMSG PassThruStartPeriodicMsg;
extern PTSTOPPERIODICMSG PassThruStopPeriodicMsg;
extern PTSTARTMSGFILTER PassThruStartMsgFilter;
extern PTSTOPMSGFILTER PassThruStopMsgFilter;
extern PTSETPROGRAMMINGVOLTAGE PassThruSetProgrammingVoltage;
extern PTREADVERSION PassThruReadVersion;
extern PTGETLASTERROR PassThruGetLastError;
extern PTIOCTL PassThruIoctl;
extern PTLOADFIRMWARE PassThruLoadFirmware;
extern PTRECOVERFIRMWARE PassThruRecoverFirmware;
extern PTREADIPSETUP PassThruReadIPSetup;
extern PTWRITEIPSETUP PassThruWriteIPSetup;
extern PTREADPCSETUP PassThruReadPCSetup;
extern PTGETPOINTER PassThruGetPointer;
extern PTGETNEXTCARDAQ PassThruGetNextCarDAQ;

#endif // Not Building the DLL
#else
#ifdef __cplusplus
#define JTYPE extern "C" long /* Linux */
#else
#define JTYPE extern long /* Linux */
#endif

JTYPE PassThruConnect(unsigned long ProtocolID, unsigned long Flags, unsigned long *pChannelID);
JTYPE PassThruDisconnect(unsigned long ChannelID);
JTYPE PassThruReadMsgs(unsigned long ChannelID, PASSTHRU_MSG *pMsg, unsigned long *pNumMsgs, unsigned long Timeout);
JTYPE PassThruWriteMsgs(unsigned long ChannelID, PASSTHRU_MSG *pMsg, unsigned long *pNumMsgs, unsigned long Timeout);
JTYPE PassThruStartPeriodicMsg(unsigned long ChannelID, PASSTHRU_MSG *pMsg, unsigned long *pMsgID, unsigned long TimeInterval);
JTYPE PassThruStopPeriodicMsg(unsigned long ChannelID, unsigned long MsgID);
JTYPE PassThruStartMsgFilter(unsigned long ChannelID, unsigned long FilterType, PASSTHRU_MSG *pMaskMsg, PASSTHRU_MSG *pPatternMsg, PASSTHRU_MSG *pFlowControlMsg, unsigned long *pMsgID);
JTYPE PassThruStopMsgFilter(unsigned long ChannelID, unsigned long MsgID);
JTYPE PassThruSetProgrammingVoltage(unsigned long Pin, unsigned long Voltage);
JTYPE PassThruReadVersion(char *pFirmwareVersion, char *pDllVersion, char *pApiVersion);
JTYPE PassThruGetLastError(char *pErrorDescription);
JTYPE PassThruIoctl(unsigned long ChannelID, unsigned long IoctlID, void *pInput, void *pOutput);

// DrewTech Only
JTYPE PassThruLoadFirmware(void);
JTYPE PassThruRecoverFirmware(void);
JTYPE PassThruReadIPSetup(char *host_name, char *ip_addr, char *subnet_mask, char *gateway, char *dhcp_addr);
JTYPE PassThruWriteIPSetup(char *host_name, char *ip_addr, char *subnet_mask, char *gateway, char *dhcp_addr);
//JTYPE PassThruReadPCSetup(char *host_name, char *ip_addr);
//JTYPE PassThruGetPointer(long vb_pointer);
JTYPE PassThruGetNextCarDAQ(char **name, unsigned long *version, char **addr);

#endif

#endif /* __J2534_H */

