/*****************************************************************************
 * THIS PROGRAM IS COPYRIGHT (c) 2007 BY DREW TECHNOLOGIES INC.              *
 * THIS PROGRAM IS PROVIDED 'AS IS' WITHOUT WARRANTY OF ANY KIND, EITHER     *
 * EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED          *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.       *
 * IN NO EVENT SHALL DREWTECH BE LIABLE FOR DAMAGES, INCLUDING ANY GENERAL,  *
 * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR    *
 * INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA   *
 * OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD     *
 * PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),  *
 * EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY    *
 * OF SUCH DAMAGES.                                                          *
 ****************************************************************************/

/*
 * This example program shows how to get GPS data from the AVIT USB host port.
 * The Prolific driver pl2303 should automatically be loaded when the USB
 * device is detected others may need to be loaded manually. Use dmesg to 
 * help debug if there are issues detecting the USB device.
 *
 * To compile On-board on AVIT with TCC:
 *   tcc -o usbgps usbgps.c
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdarg.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#ifdef WIN32
#include <winsock2.h>
#include <windows.h>
#endif

#define NUMOFLOOPSMAX 10000

/*
********************************************************************************
** Main function
*******************************************************************************
*/
int main(int argc, char **argv)
{
	int RetVal, NumLoops;
	int bytesread;
	int Fildes;
	speed_t speed;
	struct termios termios;
	struct termios *termios_p;
	struct termio termio;
	char Data_string[256];


/* use the O_NONBLOCK to not block, don't use this flag if you want to wait for the next data message */ 
	Fildes = open("/dev/ttyUSB0",O_RDWR | O_NOCTTY | O_NONBLOCK, 0 );
	if(Fildes < 0)
	{
		printf("Error Opening /dev/ttyUSB0\n");
	    exit(1);
	}
	termios_p = &termios;

/* The AVIT serial port defaults to 38400 baud.  To change the rate to the standard 4800 you
 * can use tcsetattr or ioctl.  See the examples below.
 */
	/* to use tcgetattr, do as below */
	tcgetattr(Fildes, termios_p); 
	speed = 12;	  // 12 = 4800, 13 = 9600, 14 = 19200, 15 = 38400
	printf("tts/0 open, set to 4800 baud\n");
	cfsetispeed(termios_p, speed); 
	cfsetospeed(termios_p, speed); 
	termios_p->c_lflag &= ~ECHO;
	tcsetattr(Fildes, TCSANOW, termios_p);

	/* to use IOCTL, use this code */
/*	RetVal = ioctl(Fildes,TCGETA,&termio);
	if(RetVal) printf("ioctl returned %d\n",RetVal);
	else
	{
		termio.c_cflag &= ~CBAUD;
		termio.c_cflag |= B4800;
		termio.c_lflag &= ~ECHO;
		RetVal = ioctl(Fildes,TCSETA,&termio);
		if(RetVal) printf("ioctl returned %d\n",RetVal);
	}
*/

	NumLoops = 0;
	do
	{
		/* read the GPS data and print it */
		bytesread = read(Fildes, Data_string, 255);
		if(bytesread > 0)
		{
			Data_string[bytesread] = 0;
			printf("%s",Data_string);
		}

#ifdef WIN32
		sleep(1);
#else
		usleep(100);
#endif

	} while(++NumLoops < NUMOFLOOPSMAX);

	close(Fildes);
}
