/*
 * simple_can is a simple demonstration program that shows CAN packets,
 * using the J2534 V0404 API. Hit Ctrl-C to stop.
 *
 * Copyright 2004 Drew Technologies, Inc.
 *
 *
 */

/* To compile On-board on ARM with TCC:
 *   tcc -o simple_can -ldavit4 simple_can.c
 *
 * To Cross-compile from a x86 Linux PC:
 *   arm-linux-gcc -o simple_can -ldavit4 simple_can.c 
 *
 * To compile on your PC under Windows:
 * (tested with Cygwin, will work with other compilers.)
 *   gcc -o simple_can -I/path/to/headers simple_can.c
 *
 */

#include <stdio.h>
#include <getopt.h>
#include <stdlib.h>
#include <string.h>

#include <j2534_v0404boilerplate.c>

static PASSTHRU_MSG Msg;

void
check (unsigned long r, const char *s, int line)
{
	if (r != STATUS_NOERROR)
	{
		char buff[256];
		PassThruGetLastError (&buff[0]);
		printf ("\nOops at line %d in %s: J2534 function returned 0x%lx. Error text was \n'%s'\n",
		line, s, r, buff);
		exit (99);
	}
}

int
main (int argc, char **argv)
{
	signed long ret;
        PASSTHRU_MSG MaskMsg, PatternMsg;
        unsigned long FilterID;
	unsigned long did; // Device ID
	unsigned long chid; // Channel ID
	int x;

	// Use the DrewTech boilerplate code to load the Windows DLL
	// Ignored under Linux.
	LoadJ2534DLL("CDPLS432.DLL");

	printf ("simple_can: bus traffic monitor\n");

	// Open a connection to the device
	ret = PassThruOpen(NULL, &did);
	check (ret, __FUNCTION__, __LINE__); // Always look for errors!

	// Connect to the CAN protocol
	ret = PassThruConnect(did, CAN, 0/*flags*/, 500000/*baud*/, &chid);
	check (ret, __FUNCTION__, __LINE__); // Always look for errors!

	// Setup a filter to pass all messages
	memset(&MaskMsg,0,sizeof(PASSTHRU_MSG));
	memset(&PatternMsg,0,sizeof(PASSTHRU_MSG));
        MaskMsg.ProtocolID = CAN;
        MaskMsg.TxFlags = 0;
        MaskMsg.DataSize = 4;
        MaskMsg.Data[0] = 0x00;
        MaskMsg.Data[1] = 0x00;
        MaskMsg.Data[2] = 0x00;
        MaskMsg.Data[3] = 0x00;
        PatternMsg.ProtocolID = CAN;
        PatternMsg.TxFlags = 0;
        PatternMsg.DataSize = 4;
        PatternMsg.Data[0] = 0x00;
        PatternMsg.Data[1] = 0x00;
        PatternMsg.Data[2] = 0x00;
        PatternMsg.Data[3] = 0x00;
        ret = PassThruStartMsgFilter(chid, PASS_FILTER, &MaskMsg, &PatternMsg, NULL, &FilterID);
	check (ret, __FUNCTION__, __LINE__); // Always look for errors!

	// Read the bus forever
	while (1)
	{
		unsigned long NumMsgs;
		signed long ret;

		NumMsgs = 1;
		ret = PassThruReadMsgs(chid, &Msg, &NumMsgs, 10000);
		if (ret == ERR_TIMEOUT || ret == ERR_BUFFER_EMPTY)
			ret = STATUS_NOERROR; // Pretend there was no error
		check (ret, __FUNCTION__, __LINE__); // Always look for errors!

		if (NumMsgs == 0) continue;

		// Print the message
		printf("MSG: DS=%ld, EDI=%ld, RxS=0x%08lx TS=%ld\n  \\__ ",
			Msg.DataSize, Msg.ExtraDataIndex, Msg.RxStatus, Msg.Timestamp);
		for (x = 0; x < Msg.DataSize && x < 24; x++)
		{
			printf("%02x ", Msg.Data[x]);
		}
		printf("\n");

		/*
		 * To bounce the message back with slight alteration, uncomment this:
		 *
		// CAN: Increment the Address by 1
		Msg.TxFlags = 0;
		Msg.Data[3]++;
		// send messages back
		NumMsgs = 1;
		ret = PassThruWriteMsgs (chid, &Msg, &NumMsgs, 0);
		check(ret, __FUNCTION__, __LINE__);
		*/
	} // while

	return 0;
}// main

