/*****************************************************************************
 * THIS PROGRAM IS COPYRIGHT (c) 2007 BY DREW TECHNOLOGIES INC.              *
 * THIS PROGRAM IS PROVIDED 'AS IS' WITHOUT WARRANTY OF ANY KIND, EITHER     *
 * EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED          *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.       *
 * IN NO EVENT SHALL DREWTECH BE LIABLE FOR DAMAGES, INCLUDING ANY GENERAL,  *
 * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR    *
 * INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA   *
 * OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD     *
 * PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),  *
 * EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY    *
 * OF SUCH DAMAGES.                                                          *
 ****************************************************************************/
/*
 * This example program sets the AVIT digital I/O pins using j2534. 
 *
 * To compile on the AVIT with TCC:
 *    tcc -o j2534_dio -ldavit4 j2534_dio.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdarg.h>

#ifdef WIN32
#include <winsock2.h>
#include <windows.h>
#else
#define FALSE 0
#define TRUE  1
#endif

#define DREWTECHONLY
#include "j2534_v0404boilerplate.c"

/*
********************************************************************************
** Main function
*******************************************************************************
*/
int main(int argc, char **argv)
{
	char error_string[256];
	char firm_ver[80],dll_ver[80],api_ver[80];
	int NumJ2534Devices, SelectedJ2534Index;
	int RetVal, i;
	unsigned long DeviceID;
	unsigned long DIOOutput, DIOInput;

    /*
    ** Find the J2534 interface and attach to the DLL 
    */
#ifdef WIN32
	NumJ2534Devices = EnumerateJ2534DLLs();
	if(NumJ2534Devices <= 0 )
	{
        printf("\nJ2534 devices not found in the registery. %s",J2534BoilerplateErrorResult);
        printf("\nUse the Install program to install the J2534 DLL.");
        exit(1);
	}

	if(NumJ2534Devices>1)
	{
		printf("\nSelect which J2534 device you want to use 1 - %d:\n",NumJ2534Devices);
		for(i=0;i<NumJ2534Devices;i++)
		{
			printf("%d: Vendor: %s; Device: %s\n",i+1,DeviceList[i].VendorName,DeviceList[i].DeviceName);
		}
		
		/* ask the user to pick one */
        do
		{
	    	printf("Enter device number (1-%d): ", NumJ2534Devices);
    	    SelectedJ2534Index = (getchar() - '1');
		}while((SelectedJ2534Index < 0) || (SelectedJ2534Index > (NumJ2534Devices - 1)));
	}
	else
	{
		SelectedJ2534Index = 0;
	}
	printf("\nUsing the J2534 Device from Vendor: %s\n",DeviceList[SelectedJ2534Index].VendorName);

    if (LoadJ2534DLL(DeviceList[SelectedJ2534Index].LibraryName))
    {
        printf("\nJ2534 DLL interface not found or not loaded, %s",J2534BoilerplateErrorResult);
        printf("\nUse the Install program to install the J2534 DLL.");
        exit(1);
    }
#else
    if (LoadJ2534DLL(NULL))
    {
        printf("\nJ2534 DLL interface not found or not loaded");
        exit(1);
    }
#endif
	RetVal = PassThruOpen(NULL, &DeviceID);
	if (RetVal != STATUS_NOERROR)
	{
		if(RetVal == ERR_DEVICE_NOT_CONNECTED)
		{
			printf("\nError: No AVIT found on the network.");
		}
		else
		{
			printf("\nError %d opening the AVIT", (int)RetVal);
		}
		exit(1);
	}		

	RetVal = PassThruReadVersion(DeviceID,firm_ver,dll_ver,api_ver);
	if (RetVal == STATUS_NOERROR)
	{
		printf("\n");
		printf("firmware version: %s\n",firm_ver);	
		printf("dll version: %s\n",dll_ver);	
		printf("api version: %s\n",api_ver);
	}
	else
	{
		PassThruGetLastError(error_string);
		printf("PassThruReadVersion returned %d!\n(%s)\n",RetVal,error_string);
    	PassThruClose(DeviceID);
		exit(1);
	}


	//	DT_WRITE_DIO example
	for (DIOOutput = 0; DIOOutput <= 0x0F; DIOOutput ++)
	{  
		RetVal = PassThruIoctl(DeviceID, DT_WRITE_DIO, &DIOOutput, NULL);
		if(RetVal)
		{
			PassThruGetLastError(error_string);
			printf("PassThruReadVersion returned %d!\n(%s)\n",RetVal,error_string);
   		 	PassThruClose(DeviceID);
			exit(1);
		}
		usleep(500000);
	}

#if 0
	//	DT_READ_DIO example
	while(1)
	{
		RetVal = PassThruIoctl(DeviceID, DT_READ_DIO, NULL, &DIOInput); 
		if(RetVal)
		{
			PassThruGetLastError(error_string);
			printf("PassThruIoctl returned %d!\n(%s)\n",RetVal,error_string);
		 	PassThruClose(DeviceID);
			exit(1);
		}

		printf("DIO = %d\n", DIOInput & 0x0F);
		usleep(100000);
	} 
#endif 

	PassThruClose(DeviceID);
}
