/*****************************************************************************
 * THIS PROGRAM IS COPYRIGHT (c) 2007 BY DREW TECHNOLOGIES INC.              *
 * THIS PROGRAM IS PROVIDED 'AS IS' WITHOUT WARRANTY OF ANY KIND, EITHER     *
 * EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED          *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.       *
 * IN NO EVENT SHALL DREWTECH BE LIABLE FOR DAMAGES, INCLUDING ANY GENERAL,  *
 * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR    *
 * INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA   *
 * OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD     *
 * PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),  *
 * EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY    *
 * OF SUCH DAMAGES.                                                          *
 ****************************************************************************/
/*
 *	This example program reads J1708 messages. 
 *
 * To compile on the AVIT using tcc:
 *    tcc -o j1708reader -ldavit4 j1708reader.c
 *
 */

#include <stdio.h>
#include <getopt.h>
#include <stdlib.h>
#include <math.h>

#ifdef WIN32
#include <time.h>
#else
#include <sys/time.h>
#endif

#include <j2534_v0404boilerplate.c>

//#define DEBUG_PRINT

#define FALSE	0
#define TRUE	1

typedef unsigned char U8;
typedef unsigned short U16;
typedef unsigned long U32;
typedef char S8;
typedef short S16;
typedef long S32;

unsigned long DeviceID;
PASSTHRU_MSG RxMsg;
PASSTHRU_MSG PatternMsg;


void check(unsigned long r, const char *s, int line)
{
	if (r != STATUS_NOERROR)
	{
		char buff[256];
		PassThruGetLastError (&buff[0]);
		printf ("\nOops at line %d in %s: J2534 function returned 0x%lx. Error text was \n'%s'\n",
		line, s, r, buff);
		exit (99);
	}
}


void serviceJ1708(unsigned long ChannelID)
{
	unsigned long NumMsgs;
	unsigned long ret;

	NumMsgs = 1;
	ret = PassThruReadMsgs(ChannelID, &RxMsg, &NumMsgs, 1);
	if (ret == ERR_TIMEOUT || ret == ERR_BUFFER_EMPTY)
		ret = STATUS_NOERROR; // Pretend there was no error
	check (ret, __FUNCTION__, __LINE__);

	if((NumMsgs > 0) && (RxMsg.DataSize > 2))
	{
		printf("MID = %d, D1 = %d, D2 = %d, D3 = %d\n", RxMsg.Data[0], RxMsg.Data[1], RxMsg.Data[2], RxMsg.Data[3]);

	}
}


int main (int argc, char **argv)
{
	SCONFIG_LIST sconfig_list;
	SCONFIG sconfig[10];
//	SBYTE_ARRAY InputMsg;

	unsigned long ret;
	unsigned long chid_J1708;
	unsigned long FilterID;

	LoadJ2534DLL("DAVIT432.DLL");

	printf ("Running J1708 Reader, control C to exit\n");

	// Initialize J1708
	ret = PassThruOpen(NULL,&DeviceID);
	check (ret, __FUNCTION__, __LINE__);

	{
		// Establish a logical communications channel
		ret = PassThruConnect (DeviceID, J1708_PS, 0, 9600, &chid_J1708);
		check (ret, __FUNCTION__, __LINE__);

		// set the pins
		sconfig_list.NumOfParams = 1;
		sconfig_list.ConfigPtr = sconfig;
		sconfig[0].Parameter = J1962_PINS;
		sconfig[0].Value = 0x0C07;
		ret = PassThruIoctl (chid_J1708, SET_CONFIG, &sconfig_list, NULL);
		check (ret, __FUNCTION__, __LINE__);
	
		RxMsg.DataSize = 1;
		RxMsg.TxFlags = 0;
		RxMsg.ProtocolID = J1708_PS;
		RxMsg.Data[0] = 0;
		PatternMsg.DataSize = 1;
		PatternMsg.TxFlags = 0;
		PatternMsg.ProtocolID = J1708_PS;
		PatternMsg.Data[0] = 0;
		ret = PassThruStartMsgFilter (chid_J1708, PASS_FILTER, &RxMsg, &PatternMsg, NULL, &FilterID);
		check (ret, __FUNCTION__, __LINE__);
	}

	
	while (1)
	{
		serviceJ1708(chid_J1708);
	}

	return 0;
}

