/*****************************************************************************
 * THIS PROGRAM IS COPYRIGHT (c) 2004 BY DREW TECHNOLOGIES INC.              *
 * THIS PROGRAM IS PROVIDED 'AS IS' WITHOUT WARRANTY OF ANY KIND, EITHER     *
 * EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED          *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.       *
 * IN NO EVENT SHALL DREWTECH BE LIABLE FOR DAMAGES, INCLUDING ANY GENERAL,  *
 * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR    *
 * INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA   *
 * OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD     *
 * PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),  *
 * EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY    *
 * OF SUCH DAMAGES.                                                          *
 ****************************************************************************/
/* 
*	This example program shows how to control the LEDs on AVIT. For a j2534
*   example see j2534_dio.c 
*
*	To compile on the AVIT with TCC:
*       tcc -o AVIT_LEDs AVIT_LEDs.c
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdarg.h>

/*
 * LED mapping
*/
#define LED_REQUIRED_BIT 	0x80
#define LED_LED1			0x02	// CarDAQ-Plus CF
#define LED_LED2			0x04	// CarDAQ-Plus #1, AVIT
#define LED_LED3			0x08	// CarDAQ-Plus #2, AVIT
#define LED_LED4			0x10	// CarDAQ-Plus #3
#define LED_LED5			0x20	// CarDAQ-Plus #4, AVIT	Yellow
#define LED_LED6			0x40	// CarDAQ-Plus #5, AVIT red

/*
********************************************************************************
** Main function
*******************************************************************************
*/
int main(int argc, char **argv)
{
	FILE * pFPin;
	unsigned char buf[3];

	pFPin = fopen("/dev/pinsw","w");
	if(pFPin == NULL)
    {
        printf("\nCould not open /dev/pinsw\n.");
        exit(1);
    }

	buf[0] = '_';
	buf[1] = 'K';
	buf[2] = LED_REQUIRED_BIT | LED_LED6;

	/* turn on the RED LED */
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn on the Yellow LED */
	buf[2] = LED_REQUIRED_BIT | LED_LED6 | LED_LED5;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn on the Green LED */
	buf[2] = LED_REQUIRED_BIT | LED_LED6 | LED_LED5 | LED_LED3;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn on the Green LED */
	buf[2] = LED_REQUIRED_BIT | LED_LED6 | LED_LED5 | LED_LED3 | LED_LED2;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn off the RED LED */
	buf[2] = LED_REQUIRED_BIT | LED_LED5 | LED_LED3 | LED_LED2;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn off the Yellow LED */
	buf[2] = LED_REQUIRED_BIT | LED_LED3 | LED_LED2;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn off the Green LED */
	buf[2] = LED_REQUIRED_BIT  | LED_LED2;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn off the Green LED */
	buf[2] = LED_REQUIRED_BIT;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	/* Put the LEDs back to 'normal' AVIT control */
	buf[2] = '0';
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	fclose(pFPin);

}
