/*****************************************************************************
 * THIS PROGRAM IS COPYRIGHT (c) 2007 BY DREW TECHNOLOGIES INC.              *
 * THIS PROGRAM IS PROVIDED 'AS IS' WITHOUT WARRANTY OF ANY KIND, EITHER     *
 * EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED          *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.       *
 * IN NO EVENT SHALL DREWTECH BE LIABLE FOR DAMAGES, INCLUDING ANY GENERAL,  *
 * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR    *
 * INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA   *
 * OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD     *
 * PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS),  *
 * EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY    *
 * OF SUCH DAMAGES.                                                          *
 ****************************************************************************/

/*
 * This example program shows how to read and set the Digital IO on AVIT
 * directly without using J2534 PassThru API. For J2534, use
 * PassThruIoctl( , , , ); DT_READ_DIO or DT_WRITE_DIO
 *
 *   To compile on theAVIT with TCC:
 *      tcc -o AVIT_DIO AVIT_DIO.c
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdarg.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/ioctl.h>

/*** DIO output mapping ***/
#define DIO_DO1			0x01	 // 1 = off, 0 = 0n (Low)
#define DIO_DO2			0x02	
#define DIO_DO3			0x03	
#define DIO_DO4			0x08	

#define IOCTL_READDIO _IO('k', 3)	// Read Digital IO
#define IOCTL_WRITEDIO _IO('k', 4)	// Write Digital IO

/*** Main function ***/
int main(int argc, char **argv)
{
	int RetVal;
	int Fildes;
	FILE * pFPin;

	unsigned char buf[3];

    printf("\nExample using fwrite for the Digital Outputs \n.");

	pFPin = fopen("/dev/pinsw","w");
	if(pFPin == NULL)
    {
        printf("\nCould not open /dev/pinsw\n.");
        exit(1);
    }

/* using fwrite for the Digital Outputs */
	buf[0] = 'D';
	buf[1] = 'O';
	buf[2] = DIO_DO1 | DIO_DO2 | DIO_DO3 | DIO_DO4;

	/* turn on the DIO off */
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn on the all DIO On */
	buf[2] = 0;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn on the DIO1 Off */
	buf[2] = DIO_DO1;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn on the DIO1 and 2 Off */
	buf[2] = DIO_DO1 | DIO_DO2;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn on the DIO1, 2 and 3 Off */
	buf[2] = DIO_DO1 | DIO_DO2 | DIO_DO3;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	sleep(1);

	/* turn on the DIO Off */
	buf[2] = DIO_DO1 | DIO_DO2 | DIO_DO3 | DIO_DO4;
	fwrite(buf, 1, 3, pFPin);
	fflush(pFPin);

	fclose(pFPin);

/* now do the same using IOCTL */
    printf("\nExample using IOCTL for the Digital Outputs \n");

	Fildes = open("/dev/pinsw",O_RDWR,0);
	if(Fildes < 0)
    {
        printf("\nCould not open /dev/pinsw\n");
        exit(1);
    }

	sleep(1);

	/* read Digital IO */
	RetVal = ioctl(Fildes, IOCTL_READDIO, 0);
	if(RetVal < 0)
	{
		printf("ioctl error %d\n",RetVal);
	}
	else
	{
		printf("Digital IO = %x\n",RetVal);
	}

	/* turn ON Digital IO */
	RetVal = ioctl(Fildes, IOCTL_WRITEDIO, 0);
	if(RetVal) printf("ioctl returned %d\n",RetVal);

	sleep(1);

	/* read Digital IO */
	RetVal = ioctl(Fildes, IOCTL_READDIO, 0);
	if(RetVal < 0)
	{
		printf("ioctl error %d\n",RetVal);
	}
	else
	{
		printf("Digital IO = %x\n",RetVal);
	}

	/* turn off digital IO */
	RetVal = ioctl(Fildes, IOCTL_WRITEDIO, (DIO_DO1 | DIO_DO2 | DIO_DO3 | DIO_DO4));
	if(RetVal) printf("ioctl returned %d\n",RetVal);

	close(Fildes);

}
